<?php
/**
 * Exchange Resets
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

function saveChanges() {
    global $_POST;
	
    $cfgFile = __PATH_EXCHANGERESETS_ROOT__.'config.json';
	if(!is_writable($cfgFile)) throw new Exception('The configuration file is not writable.');
	$pluginConfig = file_get_contents($cfgFile);
	if(!$pluginConfig) throw new Exception('Error loading config file.');
	$pluginConfig = json_decode($pluginConfig, true);
	if(!is_array($pluginConfig)) throw new Exception('Error loading config file.');
	
	if(!Validator::UnsignedNumber($_POST['setting_1'])) throw new Exception('Submitted setting is not valid (credit_config)');
	$pluginConfig['credit_config'] = $_POST['setting_1'];
	
	$fp = fopen($cfgFile, 'w');
	if(!fwrite($fp, json_encode($pluginConfig))) throw new Exception('There has been an error while saving changes.');
	fclose($fp);
}

if(check_value($_POST['submit_changes'])) {
	try {
		saveChanges();
		message('success', 'Settings successfully saved.');
	} catch (Exception $ex) {
		message('error', $ex->getMessage());
	}
}

if(check_value($_GET['checkusercplinks'])) {
	try {
		$ExchangeResets = new \Plugin\ExchangeResets\ExchangeResets();
		$ExchangeResets->checkPluginUsercpLinks();
		message('success', 'UserCP Links Successfully Added!');
	} catch (Exception $ex) {
		message('error', $ex->getMessage());
	}
}

// load configs
$pluginConfig = file_get_contents(__PATH_EXCHANGERESETS_ROOT__.'config.json');
if(!$pluginConfig) throw new Exception('Error loading config file.');
$pluginConfig = json_decode($pluginConfig, true);
if(!is_array($pluginConfig)) throw new Exception('Error loading config file.');

// credit system
$creditSystem = new CreditSystem();
?>
<h2>Exchange Resets Settings</h2>
<form action="" method="post">
	<table class="table table-striped table-bordered table-hover module_config_tables">
		<tr>
			<th>Credit Configuration<br/><span>Select the type of credits the player will be rewarded when exchanging their resets.</span></th>
			<td>
				<?php echo $creditSystem->buildSelectInput("setting_1", $pluginConfig['credit_config'], "form-control"); ?>
			</td>
		</tr>
		<tr>
            <td colspan="2"><input type="submit" name="submit_changes" value="Save Changes" class="btn btn-success"/></td>
        </tr>
    </table>
</form>

<hr>

<h2>UserCP Links</h2>
<p>Click the button below to automatically add the plugin's links to the user control panel menu.</p>
<a href="<?php echo admincp_base('exchangeresets&page=settings&checkusercplinks=1'); ?>" class="btn btn-primary">Add UserCP Links</a>